﻿/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
 © i-net software 1998-2012

*/ 
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Diagnostics;
using System.Text;
using System.Windows.Forms;
using System.Globalization;
using System.Threading;
using inet.Viewer.WinForms;
using inet.Viewer.Data;

namespace inet.Viewer
{
    /// <summary>
    /// This Form shows an example on how to use the ReportViewer
    /// </summary>
    public partial class ReportViewerExampleTest : Form
    {
        /// <summary>
        /// 
        /// </summary>
        public ReportViewerExampleTest()
        {
            InitializeComponent();                     
        }       

        /// <summary>
        /// Main methods that shows this ReportViewerExample
        /// </summary>
        /// <param name="args"></param>
        [STAThread]        
        public static void Main(string[] args)
        {
            try
            {
                ReportViewerExampleTest form = new ReportViewerExampleTest();
                form.ShowDialog();
            }
            catch (Exception e)
            {
                MyMessageBox.Show(e.Message, e.StackTrace, strings.ErrorMessage);
            }
        }       
                
        
        private void openFileDialog1_FileOk(object sender, CancelEventArgs e)
        {

        }

        /// <summary>
        /// Invoked when clicked on Show Button.
        /// This method checks whether the location is a url or a file location
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnShow_Click(object sender, EventArgs e)
        {
            ShowReport();
        }

        /// <summary>
        /// Gets the location of the report from text input field, checks which type of location it is
        /// and adds this as a ReportView. 
        /// </summary>
        private void ShowReport()
        {
            try
            {
                // Check if location is a url or a file
                string url = txtFile.Text;
                IReportRenderData data = null;
                if (inet.Viewer.HTML.ReportViewer.IsLocationURL(url) && !inet.Viewer.HTML.ReportViewer.isLocationFile(url))
                {
                    // Server
                    data = new ReportRenderDataServer(url);
                }
                if (inet.Viewer.HTML.ReportViewer.isLocationFile(url) && !inet.Viewer.HTML.ReportViewer.IsLocationURL(url))
                {
                    // Filesystem
                    data = new ReportRenderDataFilesystem(url);
                }
                if (data != null)
                {
                    // create the view
                    inet.Viewer.HTML.ReportView view = new inet.Viewer.HTML.ReportView(data);
                    //view.ReportTitle = "This is the report for June 2012";    
                    // add view to the ReportViewer
                    this.reportViewer1.AddReportView(view);
                }
            }
            catch (Exception ex)
            {
                MyMessageBox.Show(ex.Message, ex.StackTrace, strings.ErrorMessage);
            }
        }

        /// <summary>
        /// Show the report with pressing "Enter"
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void txtFile_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                ShowReport();
            }
        }

        private void btnUrl_Click(object sender, EventArgs e)
        {
            URLRenderData urlData = new URLRenderData( txtFile.Text);
            IRenderData rData = urlData as IRenderData;
            byte[] bData = rData.PageData(1);

            Console.WriteLine(urlData.ReportTitle);
            Console.WriteLine(urlData.ReportLocation);
            Console.WriteLine(urlData.PageCount);
            Console.WriteLine(urlData.GroupTree);

            Graphics2DPainter painter = new Graphics2DPainter();
            EmptyPageView pageView = new EmptyPageView();
            
            Image img = new Bitmap(pictureBox1.Width, pictureBox1.Height);
            painter.Graphics = Graphics.FromImage(img);
            painter.GraphicsImage = img;
            PageLoader pLoader = new PageLoader(painter, pageView, true, false);
                        
            byte[] groupTreeData = urlData.GroupTree;
            GroupLoader gLoader = new GroupLoader(null, groupTreeView1);
            gLoader.Data = groupTreeData;
            gLoader.LoadData(false);

            pLoader.PaintPage(bData);
            pictureBox1.Image = img;       
        }    
    }
}
